function [Input, NumericalOut, AnalyticOut,NumericalOut_NP]  = Plot_Figure_2DEF
close all
Folders = {'Wnt Pathway','ERK Pathway','Tgfbeta Pathway'};
for gg = 1:length(Folders);
%Recall parameters
OldFolder = cd(Folders{gg});
K = ParFun;
Knp = ParFun_NonPhys; % Nonphysiological parameters
S = SimFun(K); %Simulation parameters

N = 100;
Input = linspace(0,S.Umax,N); %Input values



NumericalOut = zeros(size(Input)); %Numerical steady state values for output
AnalyticOut = zeros(size(Input)); %Analytic Steady state values for output

NumericalOut_NP = zeros(size(Input)); %Numerical steady state values outside phys parameter regime

for i = 1:length(Input)
    
    if i>1
    
    [Yss, Error] = SSFun(K,S,Input(i)); %Solve for steady-state at ith input
    if Error
    error('Increase S.SS_Time') %Solver did not reach a steady-state
    end
    [Yssnp, Error] = SSFun(Knp,S,Input(i)); %Solve for steady-state at ith input outside phys parameter regime
    if Error
    error('Increase S.SS_Time') %Solver did not reach a steady-state
    end

    NumericalOut(i) = Yss(S.Ind);
    NumericalOut_NP(i) = Yssnp(S.Ind);
    
    AnalyticOut(i) = LinFun(K,Input(i)); %Calculate analytic steady-state at ith input from linear equation
    end
end

%Plot Input-Output curve & Linear analytical solution

figure, plot(Input,NumericalOut,'k','LineWidth', 4)
hold on
plot(Input,AnalyticOut,'r','LineWidth', 4)
xlim([0, max(Input)])
ylim([0, max(NumericalOut)])
L = legend('Numerical solution', 'Analytical solution');
L.Location = 'southeast';
xlabel(S.InputName)
ylabel(S.OutputName)
title(S.Title)


figure
plot(Input,NumericalOut_NP,'Color', [.7 .7 .7],'LineWidth', 4)
xlim([0 max(Input)])
ylim([0 max(NumericalOut_NP)])
L = legend('Numerical solution outside physiological regime');
L.Location = 'southeast';
xlabel(S.InputName)
ylabel(S.OutputName)
title(S.Title)

cd(OldFolder)

end
end